/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.servermenu;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.components.ServerButton;
import pro.gravit.launcher.gui.components.UserBlock;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.AbstractScene;
import pro.gravit.launcher.gui.scenes.interfaces.SceneSupportUserBlock;
import pro.gravit.launcher.runtime.client.ServerPinger;
import pro.gravit.utils.helper.CommonHelper;

public class ServerMenuScene
extends AbstractScene
implements SceneSupportUserBlock {
    private List<ClientProfile> lastProfiles;
    private UserBlock userBlock;

    public ServerMenuScene(JavaFXApplication application) {
        super("scenes/servermenu/servermenu.fxml", application);
    }

    @Override
    public void doInit() {
        this.userBlock = new UserBlock(this.layout, new AbstractScene.SceneAccessor());
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#settings")).setOnAction(e -> {
            try {
                this.switchScene(this.application.gui.globalSettingsScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        ScrollPane scrollPane = (ScrollPane)LookupHelper.lookup((Node)this.layout, "#servers");
        this.reset();
        this.isResetOnShow = true;
    }

    @Override
    public void reset() {
        if (this.lastProfiles == this.application.profilesService.getProfiles()) {
            return;
        }
        this.lastProfiles = this.application.profilesService.getProfiles();
        LinkedHashMap<ClientProfile, ServerButtonCache> serverButtonCacheMap = new LinkedHashMap<ClientProfile, ServerButtonCache>();
        ArrayList<ClientProfile> profiles = new ArrayList<ClientProfile>(this.lastProfiles);
        profiles.sort(Comparator.comparingInt(ClientProfile::getSortIndex).thenComparing(ClientProfile::getTitle));
        int position = 0;
        for (ClientProfile profile2 : profiles) {
            ServerButtonCache cache = new ServerButtonCache();
            cache.serverButton = ServerButton.createServerButton(this.application, profile2);
            cache.position = position++;
            serverButtonCacheMap.put(profile2, cache);
        }
        ScrollPane scrollPane = (ScrollPane)LookupHelper.lookup((Node)this.layout, "#servers");
        VBox serverList = (VBox)scrollPane.getContent();
        serverList.setSpacing(20.0);
        serverList.getChildren().clear();
        this.application.pingService.clear();
        serverButtonCacheMap.forEach((profile, serverButtonCache) -> {
            EventHandler handle = event -> {
                if (!event.getButton().equals((Object)MouseButton.PRIMARY)) {
                    return;
                }
                this.changeServer((ClientProfile)profile);
                try {
                    this.switchScene(this.application.gui.serverInfoScene);
                    this.application.gui.serverInfoScene.reset();
                }
                catch (Exception e) {
                    this.errorHandle(e);
                }
            };
            serverButtonCache.serverButton.addTo((Pane)serverList, serverButtonCache.position);
            serverButtonCache.serverButton.setOnMouseClicked((EventHandler<? super MouseEvent>)handle);
        });
        CommonHelper.newThread((String)"ServerPinger", (boolean)true, () -> {
            for (ClientProfile profile : this.lastProfiles) {
                for (ClientProfile.ServerProfile serverProfile : profile.getServers()) {
                    if (!serverProfile.socketPing || serverProfile.serverAddress == null) continue;
                    try {
                        ServerPinger pinger = new ServerPinger(serverProfile, profile.getVersion());
                        ServerPinger.Result result = pinger.ping();
                        this.contextHelper.runInFxThread(() -> this.application.pingService.addReport(serverProfile.name, result));
                    }
                    catch (IOException iOException) {}
                }
            }
        }).start();
        this.userBlock.reset();
    }

    @Override
    public UserBlock getUserBlock() {
        return this.userBlock;
    }

    @Override
    public String getName() {
        return "serverMenu";
    }

    private void changeServer(ClientProfile profile) {
        this.application.profilesService.setProfile(profile);
        this.application.runtimeSettings.lastProfile = profile.getUUID();
    }

    static class ServerButtonCache {
        public ServerButton serverButton;
        public int position;

        ServerButtonCache() {
        }
    }
}

